unit Service3;

interface
uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls,
  Service1;

//     
type TIQNotify = procedure
                (Sender : TObject; X,Y : integer; Item : TQItem) of object;
type TDDisplay = class(TIQueue)
 private
   // ---------------------------------------
   // 
   fDDisplay   : TImage;     //     
   //  
   fDColor     : TColor;     // Display color.   
   fBColor     : TColor;     // Beam color.     
   fGColor     : TColor;     // Grid color.      
   fAColor     : Tcolor;     // Axes color.      
   //  
   fEnHGrid    : boolean;    //    
   fEnVGrid    : boolean;    //    
   fEnCapt     : boolean;    //     
   //  
   fZeroTop    : integer;    // Top -    ( X)
   fGNumX      : integer;    //    
   fGNumH      : integer;    //       X
   fSens       : integer;    //  (   )
   fScaleY     : double;     //   
   //  
   fMdHold     : double;     //   
   //  
   fOnDrawItem : TIQNotify;  //   -  
   fOnLargItem : TIQNotify;  //   -   
   // 
   fXStep      : integer;    //       
   fCount      : integer;    //   
   // ---------------------------------------
   //   
   //        
   procedure ClearDisplay(RqFillColor, RqRenColor : TColor);
   //   
   procedure DrawGridLine();
   //      (  )
   procedure DrawZeroLine();
   //    Item    Image.Top
   function  ValueToTop(Item : TQItem) : integer;
   //        
   procedure DrawCurrentCaption(Item : TQItem);
   //     (  )
   procedure DrawCurrentLine(Item : TQItem);
   //         
   procedure DrawGoToNextLine(Item : TQItem);
   // ---------------------------------------
   //    
   //    -   
   procedure RunOnDrawItem(X,Y : integer; Item : TQItem);
   //    -   
   procedure RunOnLargItem(X,Y : integer; Item : TQItem);
   // ---------------------------------------
 public
   constructor Create (RqDisplay : TComponent);
   //     (  )
   procedure ShowItemQueue(); override;
   // ---------------------------------------
   //  
   //    
   property EnHGrid : boolean read fEnHGrid write fEnHGrid;
   //    
   property EnVGrid : boolean read fEnVGrid write fEnVGrid;
   //     
   property EnCapt : boolean read fEnCapt write fEnCapt;
   //  (   )
   property Sens : integer read fSens write fSens;
   //   
   property MdHold : double read fMdHold write fMdHold;
   // ---------------------------------------
   //     
   //   -  
   property OnDrawItem : TIQNotify read fOnDrawItem write fOnDrawItem;
   //   -   
   property OnLargItem : TIQNotify read fOnLargItem write fOnLargItem;
   // ---------------------------------------
end;

implementation

// -----------------------------------------------------------------------
//     TDDisplay
// -----------------------------------------------------------------------
// 
constructor TDDisplay.Create (RqDisplay : TComponent);
begin
  if (RqDisplay is TImage)
  then begin
     inherited Create(RqDisplay);  //     TIQueue
     // 
     fDDisplay := (RqDisplay as TImage);
     //  
     fDColor   := clBackground;    // Display color.   
     fBColor   := clLime;          // Beam color.     
     fGColor   := clBtnShadow;     // Grid color.      
     fAColor   := clBtnHighlight;  // Axes color.      
     //  
     fEnHGrid  := True;       //    
     fEnVGrid  := True;       //    
     fEnCapt   := True;       //   
     //  
     fGNumX  := MaxCount;     //      
     fGNumH  := 5;            //       X
     fSens   := 10;           //  (   )
     //  
     fMdHold := -1;           //   
  end;
end;

// -----------------------------------------------------------------------
//     
// -----------------------------------------------------------------------
//    -   
procedure TDDisplay.RunOnDrawItem(X,Y : integer; Item : TQItem);
begin
  if Assigned(fOnDrawItem)
  then begin
    fOnDrawItem(Self, X, Y, Item);
  end;
end;
// -----------------------------------------------------------------------
//    -   
procedure TDDisplay.RunOnLargItem(X,Y : integer; Item : TQItem);
begin
  if Assigned(fOnLargItem)
  then begin
    fOnLargItem(Self, X, Y, Item);
  end;
end;

// -----------------------------------------------------------------------
//  
// -----------------------------------------------------------------------
//    Item    Image.Top
function TDDisplay.ValueToTop(Item : TQItem) : integer;
begin
  Result := fZeroTop;  // Top -    ( X)
  if Assigned(Item)
  then begin
    Result := fZeroTop - Trunc(fScaleY * Item.RData);
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.ClearDisplay(RqFillColor, RqRenColor : TColor);
begin
  if (fDisplay is TImage)
  then begin
     with fDDisplay do
     begin
        // Top -    
        fZeroTop := Height div 2;
        //   
        fScaleY  := fZeroTop / (fSens * fGNumH);
        //     
        fXStep := Width div fGNumX;
        fCount := 0;
        //    
        Canvas.Brush.Style := bsSolid;
        Canvas.Brush.Color := RqFillColor;
        //   
        Canvas.FillRect(Rect(0, 0, Width, Height));
        //     
        DrawGridLine();
        //   
        DrawZeroLine();
        //     
        Canvas.Pen.Color := RqRenColor;
     end;
  end;
end;
// -----------------------------------------------------------------------
//   
procedure TDDisplay.DrawGridLine();
var Step, Count : integer;
begin
  with fDDisplay do
  begin
    //    
    if fEnHGrid
    then begin
       Step := fZeroTop div fGNumH;
       Canvas.Pen.Color := fGColor;
       for Count := 0 to fGNumH do
       begin
          //      
          Canvas.MoveTo ( 0,     fZeroTop - Count * Step);
          Canvas.LineTo ( Width, fZeroTop - Count * Step);
          //      
          Canvas.MoveTo ( 0,     fZeroTop + Count * Step);
          Canvas.LineTo ( Width, fZeroTop + Count * Step);
       end;
    end;
    //    
    if fEnVGrid
    then begin
       Step := Width div fGNumX;
       Canvas.Pen.Color := fGColor;
       for Count := 0 to fGNumX do
       begin
         Canvas.MoveTo ( Count * Step, 0);
         Canvas.LineTo ( Count * Step, Height);
       end;
    end;
  end; // of with fDDisplay
end;
// -----------------------------------------------------------------------
//      (  )
procedure TDDisplay.DrawZeroLine();
var Step, Count : integer;
begin
  with fDDisplay do
  begin
    //   
    Canvas.Pen.Color := fAColor;
    Canvas.MoveTo(0, fZeroTop);
    Canvas.LineTo(Width, fZeroTop);
    //     
    Step := Width div fGNumX;
    for Count := 0 to fGNumX do
    begin
      Canvas.MoveTo ( Count * Step, fZeroTop - 3);
      Canvas.LineTo ( Count * Step, fZeroTop + 3);
    end;
  end;
end;
// -----------------------------------------------------------------------
//        
procedure TDDisplay.DrawCurrentCaption(Item : TQItem);
begin
  with fDDisplay do
  begin
     //     
     if (fMdHold > 0) and (fMdHold < Abs(Item.RData))
     then Canvas.Font.Color := RGB(255,0,0)     //   
     else Canvas.Font.Color := RGB(0,255,255);
     //    
     if fEnCapt
     then begin
        Canvas.TextOut ( fCount * fXStep + 1,
              ValueToTop(Item) - Canvas.TextHeight('Y'),
              FormatFloat('#0.', Item.RData) );
     end;
  end;
end;
// -----------------------------------------------------------------------
//    
procedure TDDisplay.DrawCurrentLine(Item : TQItem);
begin
  with fDDisplay do
  begin
    DrawCurrentCaption(Item);
    // fCount * fXStep     
    // fZeroTop  Y  
    // fZeroTop - RqValue     Y
    Canvas.MoveTo(fCount * fXStep, ValueToTop(Item));
    fCount := fCount + 1;
    Canvas.LineTo(fCount * fXStep, ValueToTop(Item));
    //    
    RunOnDrawItem(fCount * fXStep, ValueToTop(Item), Item);
  end;
end;
// -----------------------------------------------------------------------
//         
procedure TDDisplay.DrawGoToNextLine(Item : TQItem);
begin
  with fDDisplay do
  begin
    Canvas.LineTo(fCount * fXStep, ValueToTop(Item));
  end;
end;
// -----------------------------------------------------------------------
//    
procedure TDDisplay.ShowItemQueue();
begin
    with fDDisplay do
    begin
      //  
      ClearDisplay(fDColor, fBColor);
      //  
      if (fICount > 0) and Assigned(fPHead) and Assigned(fPTail)
      then begin
         fPBuf := fPHead;
         repeat
            //    
            DrawCurrentLine(fPBuf);
            //     
            fPBuf := fPBuf.PNext;
            if Assigned(fPBuf)
            then begin
              //      
              DrawGoToNextLine(fPBuf);
            end;
         //      
         until not Assigned(fPBuf);
         // 
         if (fMdHold > 0) and (fMdHold < Abs(fPTail.RData))
         then begin
            //     -   
            RunOnLargItem((fGNumX -1) * fXStep,
                           ValueToTop(fPTail), fPTail);
         end;
      end;
    end;
end;
// -----------------------------------------------------------------------
// -----------------------------------------------------------------------
end.

